/*
 * Decompiled with CFR 0.152.
 */
package fuzs.puzzleslib.client.core;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import fuzs.puzzleslib.api.client.event.ModelEvents;
import fuzs.puzzleslib.api.client.renderer.ItemDecoratorRegistry;
import fuzs.puzzleslib.client.core.ClientModConstructor;
import fuzs.puzzleslib.client.init.builder.ModScreenConstructor;
import fuzs.puzzleslib.client.init.builder.ModSpriteParticleRegistration;
import fuzs.puzzleslib.client.resources.model.DynamicModelBakingContext;
import fuzs.puzzleslib.impl.PuzzlesLib;
import fuzs.puzzleslib.mixin.client.accessor.MinecraftAccessor;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import net.fabricmc.fabric.api.client.keybinding.v1.KeyBindingHelper;
import net.fabricmc.fabric.api.client.model.BakedModelManagerHelper;
import net.fabricmc.fabric.api.client.model.ModelLoadingRegistry;
import net.fabricmc.fabric.api.client.particle.v1.ParticleFactoryRegistry;
import net.fabricmc.fabric.api.client.rendering.v1.BlockEntityRendererRegistry;
import net.fabricmc.fabric.api.client.rendering.v1.BuiltinItemRendererRegistry;
import net.fabricmc.fabric.api.client.rendering.v1.EntityModelLayerRegistry;
import net.fabricmc.fabric.api.client.rendering.v1.EntityRendererRegistry;
import net.fabricmc.fabric.api.client.rendering.v1.LivingEntityFeatureRendererRegistrationCallback;
import net.fabricmc.fabric.api.client.rendering.v1.TooltipComponentCallback;
import net.fabricmc.fabric.api.event.client.ClientSpriteRegistryCallback;
import net.fabricmc.fabric.api.resource.IdentifiableResourceReloadListener;
import net.fabricmc.fabric.api.resource.ResourceManagerHelper;
import net.minecraft.class_1087;
import net.minecraft.class_1088;
import net.minecraft.class_1092;
import net.minecraft.class_1124;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1703;
import net.minecraft.class_1792;
import net.minecraft.class_2394;
import net.minecraft.class_2396;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_2960;
import net.minecraft.class_304;
import net.minecraft.class_310;
import net.minecraft.class_3264;
import net.minecraft.class_3300;
import net.minecraft.class_3302;
import net.minecraft.class_3695;
import net.minecraft.class_3883;
import net.minecraft.class_3887;
import net.minecraft.class_3917;
import net.minecraft.class_3929;
import net.minecraft.class_437;
import net.minecraft.class_5272;
import net.minecraft.class_5601;
import net.minecraft.class_5607;
import net.minecraft.class_5614;
import net.minecraft.class_5617;
import net.minecraft.class_5632;
import net.minecraft.class_5684;
import net.minecraft.class_583;
import net.minecraft.class_6395;
import net.minecraft.class_707;
import org.apache.logging.log4j.util.Strings;

public class FabricClientModConstructor {
    private final String modId;
    private final List<Consumer<DynamicModelBakingContext>> modelBakingListeners = Lists.newArrayList();

    private FabricClientModConstructor(String modId, ClientModConstructor constructor) {
        this.modId = modId;
        constructor.onConstructMod();
    }

    private ClientModConstructor.BlockEntityRenderersContext getBlockEntityRenderersContext() {
        return new ClientModConstructor.BlockEntityRenderersContext(){

            @Override
            public <T extends class_2586> void registerBlockEntityRenderer(class_2591<? extends T> blockEntityType, class_5614<T> blockEntityRendererProvider) {
                Objects.requireNonNull(blockEntityType, "block entity type is null");
                Objects.requireNonNull(blockEntityRendererProvider, "block entity renderer provider is null");
                BlockEntityRendererRegistry.register(blockEntityType, blockEntityRendererProvider);
            }
        };
    }

    private ClientModConstructor.EntityRenderersContext getEntityRenderersContext() {
        return new ClientModConstructor.EntityRenderersContext(){

            @Override
            public <T extends class_1297> void registerEntityRenderer(class_1299<? extends T> entityType, class_5617<T> entityRendererProvider) {
                Objects.requireNonNull(entityType, "entity type is null");
                Objects.requireNonNull(entityRendererProvider, "entity renderer provider is null");
                EntityRendererRegistry.register(entityType, entityRendererProvider);
            }
        };
    }

    private <T extends class_5632> void registerClientTooltipComponent(Class<T> type, Function<? super T, ? extends class_5684> factory) {
        Objects.requireNonNull(type, "tooltip component type is null");
        Objects.requireNonNull(factory, "tooltip component factory is null");
        TooltipComponentCallback.EVENT.register(data -> {
            if (data.getClass() == type) {
                return (class_5684)factory.apply(data);
            }
            return null;
        });
    }

    private ClientModConstructor.ParticleProvidersContext getParticleProvidersContext() {
        return new ClientModConstructor.ParticleProvidersContext(){

            @Override
            public <T extends class_2394> void registerParticleProvider(class_2396<T> type, class_707<T> provider) {
                Objects.requireNonNull(type, "particle type is null");
                Objects.requireNonNull(provider, "particle provider is null");
                ParticleFactoryRegistry.getInstance().register(type, provider);
            }

            @Override
            public <T extends class_2394> void registerParticleFactory(class_2396<T> type, ModSpriteParticleRegistration<T> factory) {
                Objects.requireNonNull(type, "particle type is null");
                Objects.requireNonNull(factory, "particle provider factory is null");
                ParticleFactoryRegistry.getInstance().register(type, factory::create);
            }
        };
    }

    private <M extends class_1703, U extends class_437> void registerMenuScreen(class_3917<? extends M> menuType, ModScreenConstructor<M, U> factory) {
        Objects.requireNonNull(menuType, "menu type is null");
        Objects.requireNonNull(factory, "screen constructor is null");
        class_3929.method_17542(menuType, factory::create);
    }

    private void registerAtlasSprite(class_2960 atlasId, class_2960 spriteId) {
        Objects.requireNonNull(atlasId, "atlas id is null");
        Objects.requireNonNull(spriteId, "sprite id is null");
        ClientSpriteRegistryCallback.event((class_2960)atlasId).register((atlasTexture, registry) -> registry.register(spriteId));
    }

    private void registerLayerDefinition(class_5601 layerLocation, Supplier<class_5607> supplier) {
        Objects.requireNonNull(layerLocation, "layer location is null");
        Objects.requireNonNull(supplier, "layer supplier is null");
        EntityModelLayerRegistry.registerModelLayer((class_5601)layerLocation, supplier::get);
    }

    private <T> void registerSearchTree(class_1124.class_1125<T> searchRegistryKey, class_1124.class_7456<T> treeBuilder) {
        Objects.requireNonNull(searchRegistryKey, "search registry key is null");
        Objects.requireNonNull(treeBuilder, "search registry tree builder is null");
        class_1124 searchTreeManager = ((MinecraftAccessor)class_310.method_1551()).getSearchRegistry();
        Objects.requireNonNull(searchTreeManager, "search tree manager is null");
        searchTreeManager.method_4801(searchRegistryKey, treeBuilder);
    }

    private ClientModConstructor.ItemModelPropertiesContext getItemPropertiesContext() {
        return new ClientModConstructor.ItemModelPropertiesContext(){

            @Override
            public void register(class_2960 name, class_6395 function) {
                Objects.requireNonNull(name, "property name is null");
                Objects.requireNonNull(function, "property function is null");
                class_5272.method_27881((class_2960)name, (class_6395)function);
            }

            @Override
            public void registerItem(class_1792 item, class_2960 name, class_6395 function) {
                Objects.requireNonNull(item, "item is null");
                Objects.requireNonNull(name, "property name is null");
                Objects.requireNonNull(function, "property function is null");
                class_5272.method_27879((class_1792)item, (class_2960)name, (class_6395)function);
            }
        };
    }

    private void onBakingCompleted(class_1092 modelManager, Map<class_2960, class_1087> models, class_1088 modelBakery) {
        DynamicModelBakingContext context = new DynamicModelBakingContext(modelManager, models, modelBakery){

            @Override
            public class_1087 bakeModel(class_2960 model) {
                Objects.requireNonNull(model, "model location is null");
                return BakedModelManagerHelper.getModel((class_1092)this.modelManager, (class_2960)model);
            }
        };
        for (Consumer<DynamicModelBakingContext> listener : this.modelBakingListeners) {
            try {
                listener.accept(context);
            }
            catch (Exception e) {
                PuzzlesLib.LOGGER.error("Unable to execute additional resource pack model processing provided by {}", (Object)this.modId, (Object)e);
            }
        }
    }

    private IdentifiableResourceReloadListener getFabricResourceReloadListener(final String id, class_3302 reloadListener, class_2960 ... dependencies) {
        ImmutableList fabricDependencies = ImmutableList.copyOf((Object[])dependencies);
        return new IdentifiableResourceReloadListener(){
            final /* synthetic */ Collection val$fabricDependencies;
            final /* synthetic */ class_3302 val$reloadListener;
            {
                this.val$fabricDependencies = collection;
                this.val$reloadListener = class_33022;
            }

            public class_2960 getFabricId() {
                return new class_2960(FabricClientModConstructor.this.modId, id);
            }

            public Collection<class_2960> getFabricDependencies() {
                return this.val$fabricDependencies;
            }

            public CompletableFuture<Void> method_25931(class_3302.class_4045 preparationBarrier, class_3300 resourceManager, class_3695 profilerFiller, class_3695 profilerFiller2, Executor executor, Executor executor2) {
                return this.val$reloadListener.method_25931(preparationBarrier, resourceManager, profilerFiller, profilerFiller2, executor, executor2);
            }
        };
    }

    private ClientModConstructor.LivingEntityRenderLayersContext getLivingEntityRenderLayersContext() {
        return new ClientModConstructor.LivingEntityRenderLayersContext(){

            @Override
            public <T extends class_1309> void registerRenderLayer(class_1299<? extends T> entityType, BiFunction<class_3883<T, ? extends class_583<T>>, class_5617.class_5618, class_3887<T, ? extends class_583<T>>> factory) {
                Objects.requireNonNull(entityType, "entity type is null");
                Objects.requireNonNull(factory, "render layer factory is null");
                LivingEntityFeatureRendererRegistrationCallback.EVENT.register((entityType1, entityRenderer, registrationHelper, context) -> {
                    if (entityType == entityType1) {
                        registrationHelper.register((class_3887)factory.apply((class_3883)entityRenderer, context));
                    }
                });
            }
        };
    }

    public static void construct(String modId, ClientModConstructor constructor) {
        if (Strings.isBlank((String)modId)) {
            throw new IllegalArgumentException("modId cannot be empty");
        }
        PuzzlesLib.LOGGER.info("Constructing client components for mod {}", (Object)modId);
        FabricClientModConstructor fabricClientModConstructor = new FabricClientModConstructor(modId, constructor);
        constructor.onClientSetup();
        constructor.onRegisterEntityRenderers(fabricClientModConstructor.getEntityRenderersContext());
        constructor.onRegisterBlockEntityRenderers(fabricClientModConstructor.getBlockEntityRenderersContext());
        constructor.onRegisterClientTooltipComponents(fabricClientModConstructor::registerClientTooltipComponent);
        constructor.onRegisterParticleProviders(fabricClientModConstructor.getParticleProvidersContext());
        constructor.onRegisterMenuScreens(fabricClientModConstructor::registerMenuScreen);
        constructor.onRegisterAtlasSprites(fabricClientModConstructor::registerAtlasSprite);
        constructor.onRegisterLayerDefinitions(fabricClientModConstructor::registerLayerDefinition);
        constructor.onRegisterSearchTrees(fabricClientModConstructor::registerSearchTree);
        constructor.onRegisterModelBakingCompletedListeners(fabricClientModConstructor.modelBakingListeners::add);
        if (!fabricClientModConstructor.modelBakingListeners.isEmpty()) {
            ModelEvents.BAKING_COMPLETED.register(fabricClientModConstructor::onBakingCompleted);
        }
        constructor.onRegisterAdditionalModels(model -> {
            Objects.requireNonNull(model, "model location is null");
            ModelLoadingRegistry.INSTANCE.registerModelProvider((manager, out) -> out.accept(model));
        });
        constructor.onRegisterItemModelProperties(fabricClientModConstructor.getItemPropertiesContext());
        constructor.onRegisterBuiltinModelItemRenderers((item, renderer) -> {
            Objects.requireNonNull(item, "item is null");
            Objects.requireNonNull(renderer, "renderer is null");
            BuiltinItemRendererRegistry.INSTANCE.register(item, renderer::renderByItem);
        });
        constructor.onRegisterClientReloadListeners((id, reloadListener) -> {
            Objects.requireNonNull(id, "reload listener id is null");
            Objects.requireNonNull(reloadListener, "reload listener is null");
            ResourceManagerHelper.get((class_3264)class_3264.field_14188).registerReloadListener(fabricClientModConstructor.getFabricResourceReloadListener(id, reloadListener, new class_2960[0]));
        });
        constructor.onRegisterLivingEntityRenderLayers(fabricClientModConstructor.getLivingEntityRenderLayersContext());
        constructor.onRegisterItemDecorations((item, decorator) -> {
            Objects.requireNonNull(item, "item is null");
            Objects.requireNonNull(decorator, "item decorator is null");
            ItemDecoratorRegistry.INSTANCE.register(item, decorator);
        });
        constructor.onRegisterKeyMappings(keyBinding -> {
            Objects.requireNonNull(keyBinding, "key mapping is null");
            KeyBindingHelper.registerKeyBinding((class_304)keyBinding);
        });
    }
}

